package mcfall.raytracer.tests;

import mcfall.math.ColumnVector;
import mcfall.math.Point;
import mcfall.math.Vector;
import mcfall.raytracer.objects.RGBIntensity;

public class LightSource extends TestCase {

	private mcfall.math.Point eye1, eye2;
	private mcfall.math.Point lightLocation1, lightLocation2;
	private mcfall.math.Point hitLocation1, hitLocation2;
	private Vector normal1, normal2;
	private mcfall.raytracer.LightSource lightSource1, lightSource2;
	private double red, green, blue;
	
	protected void setUp() throws Exception {
		eye1 = new Point (1, 1, 0);
		lightLocation1 = new Point (-1, 1, 0);
		hitLocation1 = new Point (0, 0, 0);
		normal1 = new ColumnVector (4);
		normal1.setValueAt(2, 1.0);
		red = 1.0;
		green = 0.5;
		blue = 0.1;
		lightSource1 = new mcfall.raytracer.LightSource (red, green, blue, lightLocation1);
		
		lightLocation2 = new Point (-1, 2, 3);
		hitLocation2 = new Point (1, -1, 1.5);
		eye2 = new Point (2, -1.5, 2);
		normal2 = new ColumnVector (4);
		normal2.setValueAt(1, 0.5);
		normal2.setValueAt(2, 1);
		normal2.setValueAt(3, -0.5);
		lightSource2 = new mcfall.raytracer.LightSource (red, green, blue, lightLocation2);
	}

	/*
	 * Test method for 'mcfall.raytracer.LightSource.computeDiffuse(Point, Vector)'
	 */
	public void testComputeDiffuse() {
		double expected = Math.sqrt(2)/2.0;
		/*  
		 * Simple case, more easily seen analytically.  The angle between the
		 * normal vector and the light source is 45 degrees, so the result should
		 * be the multipliation of each intensity and sqrt(2)/2
		 */ 		
		RGBIntensity result = lightSource1.computeDiffuse(hitLocation1, normal1);
		assertAlmostEquals(expected*red, result.getRed());
		assertAlmostEquals(expected*green, result.getGreen());
		assertAlmostEquals(expected*blue, result.getBlue());
		
		/**
		 * Now try with a more difficult case, ensuring that each value of the 
		 * light source, point hit, normal, and eye location are different
		 */
		result = lightSource2.computeDiffuse(hitLocation2, normal2);
		assertAlmostEquals(0.26135, result.getRed());
		assertAlmostEquals(0.13068, result.getGreen());
		assertAlmostEquals(0.02614, result.getBlue());
	}

	/*
	 * Test method for 'mcfall.raytracer.LightSource.computeSpecular(Point, Point, Vector, int)'
	 */
	public void testComputeSpecular() {

		RGBIntensity result;
		result = lightSource1.computeSpecular(eye1, hitLocation1, normal1, 1);
		assertAlmostEquals (1.0, result.getRed());
		assertAlmostEquals (0.5, result.getRed());
		assertAlmostEquals (0.1, result.getRed());
		
		result = lightSource2.computeSpecular(eye2, hitLocation2, normal2, 3);
		assertAlmostEquals (0.11612, result.getRed());
		assertAlmostEquals (0.05806, result.getGreen());
		assertAlmostEquals (0.01161, result.getBlue());				
	}

}
